/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.GtkChildWindow;
import com.sun.glass.ui.gtk.GtkCommonDialogs;
import com.sun.glass.ui.gtk.GtkCursor;
import com.sun.glass.ui.gtk.GtkPixels;
import com.sun.glass.ui.gtk.GtkRobot;
import com.sun.glass.ui.gtk.GtkTimer;
import com.sun.glass.ui.gtk.GtkView;
import com.sun.glass.ui.gtk.GtkWindow;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import com.sun.prism.impl.PrismSettings;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class GtkApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private static final String SWT_INTERNAL_CLASS = "org.eclipse.swt.internal.gtk.OS";
    private static final int forcedGtkVersion;
    public static int screen;
    public static long display;
    public static long visualID;
    static float overrideUIScale;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private static final int QUERY_ERROR = -2;
    private static final int QUERY_NO_DISPLAY = -1;
    private static final int QUERY_USE_CURRENT = 1;
    private static final int QUERY_LOAD_GTK2 = 2;
    private static final int QUERY_LOAD_GTK3 = 3;
    private Object eventLoopExitEnterPassValue;

    private static float getFloat(String string, float f, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            string3 = System.getenv(string);
        }
        if (string3 == null) {
            return f;
        }
        float f2 = (string3 = string3.trim()).endsWith("%") ? (float)Integer.parseInt(string3.substring(0, string3.length() - 1)) / 100.0f : (string3.endsWith("DPI") || string3.endsWith("dpi") ? (float)Integer.parseInt(string3.substring(0, string3.length() - 3)) / 96.0f : Float.parseFloat(string3));
        if (PrismSettings.verbose) {
            System.out.println(string2 + f2);
        }
        return f2;
    }

    GtkApplication() {
        int n = forcedGtkVersion == 0 ? AccessController.doPrivileged(() -> {
            String string = System.getProperty("jdk.gtk.version", "3");
            int n = 0;
            if ("3".equals(string) || string.startsWith("3.")) {
                n = 3;
            } else if ("2".equals(string) || string.startsWith("2.")) {
                n = 2;
            }
            return n;
        }) : forcedGtkVersion;
        boolean bl = AccessController.doPrivileged(() -> Boolean.getBoolean("jdk.gtk.verbose"));
        overrideUIScale = PrismSettings.allowHiDPIScaling ? AccessController.doPrivileged(() -> Float.valueOf(GtkApplication.getFloat("glass.gtk.uiScale", -1.0f, "Forcing UI scaling factor: "))).floatValue() : -1.0f;
        int n2 = GtkApplication._queryLibrary(n, bl);
        AccessController.doPrivileged(() -> {
            if (n2 == -1) {
                throw new UnsupportedOperationException("Unable to open DISPLAY");
            }
            if (n2 == 1) {
                if (bl) {
                    System.out.println("Glass GTK library to load is already loaded");
                }
            } else if (n2 == 2) {
                if (bl) {
                    System.out.println("Glass GTK library to load is glassgtk2");
                }
                NativeLibLoader.loadLibrary("glassgtk2");
            } else if (n2 == 3) {
                if (bl) {
                    System.out.println("Glass GTK library to load is glassgtk3");
                }
                NativeLibLoader.loadLibrary("glassgtk3");
            } else {
                throw new UnsupportedOperationException("Internal Error");
            }
            return null;
        });
        int n3 = GtkApplication._initGTK(n, bl, overrideUIScale);
        if (n3 == -1) {
            throw new RuntimeException("Error loading GTK libraries");
        }
        boolean bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (!bl2) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    private static native int _queryLibrary(int var0, boolean var1);

    private static native int _initGTK(int var0, boolean var1, float var2);

    private void initDisplay() {
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Object v = map.get("XDisplay");
            if (v != null) {
                display = (Long)v;
            }
            if ((v = map.get("XVisualID")) != null) {
                visualID = (Long)v;
            }
            if ((v = map.get("XScreenID")) != null) {
                screen = (Integer)v;
            }
        }
    }

    private void init() {
        this.initDisplay();
        long l = 0L;
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Long l2 = (Long)map.get("javafx.embed.eventProc");
            l = l2 == null ? 0L : l2;
        }
        boolean bl = AccessController.doPrivileged(() -> Boolean.getBoolean("sun.awt.disablegrab") || Boolean.getBoolean("glass.disableGrab"));
        this._init(l, bl);
    }

    @Override
    protected void runLoop(Runnable runnable) {
        boolean bl = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (bl) {
            this.init();
            GtkApplication.setEventThread(Thread.currentThread());
            runnable.run();
            return;
        }
        boolean bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("glass.noErrorTrap"));
        Thread thread = AccessController.doPrivileged(() -> new Thread(() -> {
            this.init();
            this._runLoop(runnable, bl2);
        }, "GtkNativeMainLoopThread"));
        GtkApplication.setEventThread(thread);
        thread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread thread = GtkApplication.getEventThread();
        if (thread != null) {
            this._terminateLoop();
            GtkApplication.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native void _terminateLoop();

    private native void _init(long var1, boolean var3);

    private native void _runLoop(Runnable var1, boolean var2);

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeAndWait(runnable);
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.submitForLaterInvocation(() -> {
                if (runnable != null) {
                    runnable.run();
                }
                countDownLatch.countDown();
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable runnable) {
        this._submitForLaterInvocation(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    private native void enterNestedEventLoopImpl();

    private native void leaveNestedEventLoopImpl();

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            this.enterNestedEventLoopImpl();
            Object object = this.eventLoopExitEnterPassValue;
            this.eventLoopExitEnterPassValue = null;
            Object object2 = object;
            return object2;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this.eventLoopExitEnterPassValue = object;
        this.leaveNestedEventLoopImpl();
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        return new GtkWindow(window, screen, n);
    }

    @Override
    public Window createWindow(long l) {
        return new GtkChildWindow(l);
    }

    @Override
    public View createView() {
        return new GtkView();
    }

    @Override
    public Cursor createCursor(int n) {
        return new GtkCursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        return new GtkCursor(n, n2, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        return GtkCursor._getBestSize(n, n2);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new GtkPixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new GtkPixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f, float f2) {
        return new GtkPixels(n, n2, intBuffer, f, f2);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public GlassRobot createRobot() {
        return new GtkRobot();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new GtkTimer(runnable);
    }

    @Override
    protected native int staticTimer_getMinPeriod();

    @Override
    protected native int staticTimer_getMaxPeriod();

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray, int n2) {
        return GtkCommonDialogs.showFileChooser(window, string, string2, string3, n, bl, extensionFilterArray, n2);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return GtkCommonDialogs.showFolderChooser(window, string, string2);
    }

    @Override
    protected native long staticView_getMultiClickTime();

    @Override
    protected native int staticView_getMultiClickMaxX();

    @Override
    protected native int staticView_getMultiClickMaxY();

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected native boolean _supportsTransparentWindows();

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1);

    static {
        Class clazz = AccessController.doPrivileged(() -> {
            try {
                return Class.forName(SWT_INTERNAL_CLASS, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                try {
                    return Class.forName(SWT_INTERNAL_CLASS, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        });
        if (clazz != null) {
            PlatformLogger platformLogger = Logging.getJavaFXLogger();
            platformLogger.fine("SWT-GTK library found. Try to obtain GTK version.");
            Method method = AccessController.doPrivileged(() -> {
                try {
                    return clazz.getMethod("gtk_major_version", new Class[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            });
            int n = 0;
            if (method != null) {
                try {
                    n = ((Number)method.invoke((Object)clazz, new Object[0])).intValue();
                }
                catch (Exception exception) {
                    platformLogger.warning("Method gtk_major_version() of the org.eclipse.swt.internal.gtk.OS class returns error. SWT GTK version cannot be detected. GTK3 will be used as default.");
                    n = 3;
                }
            }
            if (n < 2 || n > 3) {
                platformLogger.warning("SWT-GTK uses unsupported major GTK version " + n + ". GTK3 will be used as default.");
                n = 3;
            }
            forcedGtkVersion = n;
        } else {
            forcedGtkVersion = 0;
        }
        AccessController.doPrivileged(() -> {
            Application.loadNativeLibrary();
            return null;
        });
        screen = -1;
        display = 0L;
        visualID = 0L;
    }
}

