---
myst:
  html_meta:
    keywords: LaTeX
---
# Comment franciser un document LaTeX ?

## Avec l'extension <ctanpkg:babel> (et son module <ctanpkg:babel-french>)

L'extension <ctanpkg:babel> maintenue par Javier Bezos permet de composer des
documents multilingues. Son appel sous LaTeX se fait par :

```{noedit}
\usepackage[⟨langue-1⟩,⟨langue-2⟩,...,⟨langue-n⟩]{babel}
```
ou, préférablement, par :
```{noedit}
\documentclass[⟨langue-1⟩,⟨langue-2⟩,...,⟨langue-n⟩,⟨autre(s) option(s)⟩]{⟨classe⟩}
[...]
\usepackage{babel}
```
afin que tous les packages sensibles à la langue chargés, par exemple <ctanpkg:varioref>
(cf. [](/3_composition/texte/renvois/renvoi_a_une_page.md)), bénéficient de
cette information sans avoir à la répéter.

Parmi les langues actuellement disponibles, on peut citer, `french`, `english`,
`german`, `spanish`, `italian`.

Dans le cas d'un document multilingue, la langue principale et activée par
défaut est la dernière déclarée. Ainsi, un document de classe `article`
multilingue en français, espagnol et allemand dont la langue par défaut doit
être le français pourra être déclaré comme suit :

```{noedit}
\documentclass[german,spanish,french]{article}
[...]
\usepackage{babel}
```

Le changement de `⟨langue⟩` se fait notamment via la commande "bascule"
`\selectlanguage{⟨langue⟩}` (où la `⟨langue⟩` doit avoir été préalablement
déclarée comme indiqué ci-dessus). Ainsi, pour passer semi-globalement en
espagnol, on peut recourir à :

```{noedit}
\selectlanguage{spanish}
```

::::{note} Le gestion de la langue française avec l'extension <ctanpkg:babel> est
assurée par son module <ctanpkg:babel-french> créé et maintenu par Daniel Flipo.
:::{warning}
Les options historiques `francais` et `frenchb` fournies par <ctanpkg:babel-french> sont
désormais obsolètes et à remplacer par `french`.
:::
::::

## Avec l'extension <ctanpkg:polyglossia>

L'extension <ctanpkg:polyglossia> est pensée pour traiter ce sujet avec
[XeLaTeX](/1_generalites/glossaire/xetex) et
[LuaLaTeX](/1_generalites/glossaire/luatex). L'appel pour le français, en tant
que langue principale, est :

```{noedit}
\usepackage{polyglossia}
\setmainlanguage{french}
```

Comme pour <ctanpkg:babel>, le changement de langue se fait notamment via la
commande "bascule" `\selectlanguage`. Ainsi, pour passer en espagnol, on peut
recourir à :

```{noedit}
\selectlanguage{spanish}
```

## Avec l'extension <ctanpkg:e-french>

:::{todo}
Section sur <ctanpkg:e-french> à compléter.
:::
